﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using HIPS.Web.UI;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using OpenQA.Selenium;
using OpenQA.Selenium.IE;
using SpecsFor.Mvc;

namespace HIPS.Web.Test.Integration
{
    [TestClass]
    class MvcAppConfig
    {
        private static SpecsForIntegrationHost integrationHost;

        [AssemblyInitialize()]
        public static void AssemblyInitialize(TestContext testContext)
        {
            var config = new SpecsForMvcConfig();
            string s = Project.Named("HIPS.Web.UI");

            // Uses Application Server Mode which means default config from template 
            // This unfortunately stops Windows Auth and it's extra work to work around.
            // See: http://blogs.msdn.com/b/robert_mcmurray/archive/2012/07/03/working-with-the-different-iis-express-modes-and-https.aspx
            // See: http://robrich.org/archive/2012/07/06/iis-express-protocolhttps.aspx
            //config.UseIISExpress()
            //    .With(s)
            //    .ApplyWebConfigTransformForConfig("Debug");

            // For now have to build and start app manually.
            config.UseApplicationAtUrl("http://localhost:60000");

            config.BuildRoutesUsing(RouteConfig.RegisterRoutes);

            config.UseBrowser(BrowserDriver.InternetExplorer);
            integrationHost = new SpecsForIntegrationHost(config);
            integrationHost.Start();
        }

        [AssemblyCleanup()]
        public static void AssemblyCleanup()
        {
            integrationHost.Shutdown();
        }
    }
}
